* Install Ubuntu Server (in this scenario 24.04.2 LTS) Minimized
* Select Install OpenSSH server
* Update and install necessary packages (or needed in template)
```bash
apt update
apt install open-vm-tools aptitude vim htop util-linux-extra -y
apt upgrade -y
```
* Disable `cloud-init`. NOTICE: Removing `cloud-init`, remove also necessary packages responsible for networking (e.g. netplan.io)
```bash
cloud-init clean --logs
touch /etc/cloud/cloud-init.disabled
```
* Change `open-vm-tools` startup order
```bash
sed -i 's/Before=cloud-init-local.service/After=dbus.service/g' /lib/systemd/system/open-vm-tools.service
```
* Allow sudo without password
```bash
sed -i /etc/sudoers -re 's/^%sudo.*/%sudo   ALL=(ALL:ALL) NOPASSWD: ALL/g'
```
* Cleanup VM for template
```bash
# cleanup current ssh keys so templated VMs get fresh key
sudo rm -f /etc/ssh/ssh_host_*
```
```bash
# add check for ssh keys on reboot...regenerate if neccessary
tee /etc/rc.local >/dev/null <<EOL
#!/bin/sh -e
#
# rc.local
#
# This script is executed at the end of each multiuser runlevel.
# Make sure that the script will "" on success or any other
# value on error.
#
# In order to enable or disable this script just change the execution
# bits.
#

# By default this script does nothing.
test -f /etc/ssh/ssh_host_dsa_key || dpkg-reconfigure openssh-server
exit 0
EOL

# make the script executable
chmod +x /etc/rc.local
```
