* Install Debian
* Update and install necessary packages (or needed in template)
```bash
apt update
apt install open-vm-tools aptitude vim htop sudo -y
apt upgrade -y
```
* Add user to sudo group (in my scenario used for ansible)
```bash
usermod -aG sudo administrator
```
* Allow sudo without password
```bash
sed -i /etc/sudoers -re 's/^%sudo.*/%sudo   ALL=(ALL:ALL) NOPASSWD: ALL/g'
```
* Cleanup VM for template
```bash
# cleanup current ssh keys so templated VMs get fresh key
rm -f /etc/ssh/ssh_host_*
```
```bash
# add check for ssh keys on reboot...regenerate if neccessary
tee /etc/rc.local >/dev/null <<EOL
#!/bin/sh -e
#
# rc.local
#
# This script is executed at the end of each multiuser runlevel.
# Make sure that the script will "" on success or any other
# value on error.
#
# In order to enable or disable this script just change the execution
# bits.
#

# By default this script does nothing.
test -f /etc/ssh/ssh_host_dsa_key || dpkg-reconfigure openssh-server
exit 0
EOL

# make the script executable
chmod +x /etc/rc.local
```
```bash
# cleanup apt
apt clean

# reset the machine-id (DHCP leases in 18.04 are generated based on this... not MAC...)
echo "" | sudo tee /etc/machine-id >/dev/null

# disable swap
swapoff --all
sed -ri '/\sswap\s/s/^#?/#/' /etc/fstab

# cleanup shell history and shutdown for templating
history -c
history -w
shutdown -h now
```
* Mark VM as a Template
* Test with Terraform